/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.ccfw.pa.system;

import com.ibm.hsc.ccfw.pa.system.PIMachineSystem;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.pa.system.PASystemLock;
import com.ibm.hwmca.fw.pa.system.PASystemLockProvider;
import com.ibm.hwmca.fw.pa.util.LockAcquisitionException;
import com.ibm.hwmca.fw.pa.util.LockHeldException;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.event.PIDumpEvent;
import com.ibm.hwmca.p.pa.event.PelDataEvent;
import com.ibm.hwmca.xfw.pa.event.DistributedDataEvent;
import com.ibm.hwmca.xfw.pa.event.DistributedDataEventLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public abstract class PIFsp
extends PIMachineSystem
implements PASystemLockProvider {
    private static final String TRACE_MASKT = "PPAFSP T";
    private static final String TRACE_MASKF = "PPAFSP F";
    private static final String TRACE_MASKD = "PPAFSP D";
    private static final String PIFSP_CFGMAP_KEY = "com.ibm.hsc.ccfw.pa.system.PIFsp";
    private static final String KEY_LIST_CONTENT_FLAGS = "ListContentsFlags";
    private static final String KEY_MAX_LEID_RETRIEVAL_COUNT = "MaxNumberOfEventEntries";
    private static final int DEFAULT_LIST_CONTENT_FLAGS = 61440;
    private static final int DEFAULT_MAX_LEID_RETRIEVAL_COUNT = 10;
    private static final String KEY_ALL_DUMP_COUNT = "AllDumpCount";
    private static final String KEY_SYSTEM_DUMP_COUNT = "SystemDumpCount";
    private static final String KEY_SP_DUMP_COUNT = "SPDumpCount";
    private static final String KEY_SMA_DUMP_COUNT = "SMADumpCount";
    private static final String KEY_OTHER_DUMP_COUNT = "OtherDumpCount";
    public static final PASystemLock DUMP_LOCK = new PASystemLock((Object)"Dump");
    private Map cimLockMap = new HashMap();

    public PIFsp() {
    }

    public PIFsp(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public PIFsp(CIMInstance cIMInstance, boolean bl) {
        super(cIMInstance, bl);
    }

    public PIFsp(PersistentData persistentData) throws PersistenceException {
        super(persistentData);
    }

    public CIMObjectPath getFSPObjectPath() {
        return this.getCIMObjectPath();
    }

    public abstract String getLocationCode();

    public abstract void setLastLogEntryID(long var1);

    public abstract long getLastLogEntryID();

    public synchronized void synchronizeSystem(Map map, DistributedDataEventLogger distributedDataEventLogger) {
        Trace.trace((String)TRACE_MASKD, (Object)this.getSystemTrace("--> synchronizeSystem"));
        long l = this.getLastLogEntryID();
        Trace.trace((String)TRACE_MASKD, (Object)this.getSystemTrace("synchronize PELs: incoming lastLeid=" + Long.toString(l, 16)));
        Vector vector = this.getPELs(map, false, 0L, l != 0L, l);
        PelDataEvent pelDataEvent = null;
        if (vector.size() != 0) {
            for (int i = vector.size() - 1; i >= 0; --i) {
                try {
                    pelDataEvent = new PelDataEvent((Object)this);
                    pelDataEvent.setSystem((PASystem)this);
                    pelDataEvent.setData((Object)((byte[])vector.get(i)));
                    Trace.trace((String)TRACE_MASKD, (Object)this.getSystemTrace("logging PEL " + (i + 1) + " of " + vector.size() + " (leid=" + Integer.toHexString(pelDataEvent.getFipsLogID()) + ", plid=" + Integer.toHexString(pelDataEvent.getPlatformLogID()) + ")"));
                    distributedDataEventLogger.log((DistributedDataEvent)pelDataEvent);
                    this.acknowledgePEL(new Long(Long.parseLong(Integer.toHexString(pelDataEvent.getFipsLogID()), 16)));
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKT, (Object)this.getSystemTrace("caught exception - ignoring PEL"));
                    Trace.trace((String)TRACE_MASKT, (Object)exception);
                }
                this.setLastLogEntryID(pelDataEvent.getFipsLogID());
            }
        }
        Trace.trace((String)TRACE_MASKD, (Object)this.getSystemTrace("outgoing lastLeid=" + Long.toString(this.getLastLogEntryID(), 16)));
        Trace.trace((String)TRACE_MASKD, (Object)this.getSystemTrace("synchronize PELs: incoming dumps"));
        Map map2 = this.queryDump();
        int n = (Integer)map2.get(KEY_ALL_DUMP_COUNT);
        if (n > 0) {
            PIDumpEvent pIDumpEvent = new PIDumpEvent((Object)this);
            pIDumpEvent.setSystem((PASystem)this);
            Trace.trace((String)TRACE_MASKD, (Object)"logging dump notification");
            distributedDataEventLogger.log((DistributedDataEvent)pIDumpEvent);
        }
        Trace.trace((String)TRACE_MASKD, (Object)this.getSystemTrace("<-- synchronizeSystem"));
    }

    public Vector getPELLogEntryIDs(Map map) {
        return this.getPELLogEntryIDs(map, false, 0L, false, 0L);
    }

    public Vector getPELLogEntryIDs(Map map, long l) {
        return this.getPELLogEntryIDs(map, false, 0L, true, l);
    }

    public Vector getPELLogEntryIDs(Map map, boolean bl, long l, boolean bl2, long l2) {
        Object object;
        Object object2;
        Trace.trace((String)TRACE_MASKD, (Object)"--> getPELLogEntryIDs");
        Trace.trace((String)TRACE_MASKD, (Object)("stoppingLogEntryID=" + Long.toString(l2, 16)));
        Vector<Long> vector = new Vector<Long>();
        int n = 1;
        if (bl) {
            n = 2;
        }
        int n2 = 61440;
        int n3 = 10;
        if (map != null) {
            object2 = (Map)map.get(PIFSP_CFGMAP_KEY);
            if (object2 == null) {
                Trace.trace((String)TRACE_MASKD, (Object)"No system configuration map for com.ibm.hsc.ccfw.pa.system.PIFsp - using defaults");
            } else {
                block23: {
                    object = (String)object2.get(KEY_LIST_CONTENT_FLAGS);
                    if (object != null) {
                        try {
                            if (((String)object).startsWith("0x") || ((String)object).startsWith("0X")) {
                                n2 = Integer.parseInt(((String)object).substring(2), 16);
                                break block23;
                            }
                            n2 = new Integer((String)object);
                        }
                        catch (Exception exception) {
                            Trace.trace((String)TRACE_MASKD, (Object)"Exception parsing ListContentsFlags - using default");
                            Trace.trace((String)TRACE_MASKD, (Object)exception);
                            n2 = 61440;
                        }
                    } else {
                        Trace.trace((String)TRACE_MASKD, (Object)"No ListContentsFlags - using default");
                    }
                }
                object = (String)object2.get(KEY_MAX_LEID_RETRIEVAL_COUNT);
                if (object != null) {
                    try {
                        n3 = Integer.parseInt((String)object);
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKD, (Object)"Exception parsing MaxNumberOfEventEntries - using default");
                        Trace.trace((String)TRACE_MASKD, (Object)exception);
                        n3 = 10;
                    }
                } else {
                    Trace.trace((String)TRACE_MASKD, (Object)"No MaxNumberOfEventEntries - using default");
                }
            }
        }
        object2 = null;
        object = null;
        long l3 = l;
        boolean bl3 = true;
        boolean bl4 = true;
        int n4 = 0;
        do {
            object2 = new Vector();
            object = new Vector();
            Trace.trace((String)TRACE_MASKD, (Object)("Polling for ids starting at " + Long.toString(l3, 16)));
            Trace.trace((String)TRACE_MASKD, (Object)("ListGenerationType=" + n));
            Trace.trace((String)TRACE_MASKD, (Object)("ListContentsFlags=" + Integer.toString(n2, 16)));
            Trace.trace((String)TRACE_MASKD, (Object)("MaxNumberOfEventEntries=" + n3));
            ((Vector)object2).addElement(new CIMProperty("ListGenerationType", new CIMValue((Object)new UnsignedInt8((short)n))));
            ((Vector)object2).addElement(new CIMProperty(KEY_LIST_CONTENT_FLAGS, new CIMValue((Object)new UnsignedInt16(n2))));
            ((Vector)object2).addElement(new CIMProperty("StartingLogEntryID", new CIMValue((Object)new UnsignedInt32(l3))));
            ((Vector)object2).addElement(new CIMProperty(KEY_MAX_LEID_RETRIEVAL_COUNT, new CIMValue((Object)new UnsignedInt32((long)n3))));
            ((Vector)object2).addElement(new CIMProperty("LocCode", new CIMValue((Object)this.getLocationCode())));
            try {
                PIHscUtil.invokeCIMMethod("localhost", this.getFSPObjectPath(), "GetListOfPlatformEventsLogEvents", (Vector)object2, (Vector)object);
            }
            catch (CIMException cIMException) {
                Trace.trace((String)TRACE_MASKT, (Object)"Exception during CIM call - results may be truncated");
                Trace.trace((String)TRACE_MASKT, (Object)((Object)cIMException));
                Trace.trace((String)TRACE_MASKD, (Object)("<-- getPELLogEntryIDs (" + vector.size() + " returned)"));
                return vector;
            }
            Object e = ((Vector)object).get(0);
            CIMValue cIMValue = null;
            cIMValue = e instanceof CIMValue ? (CIMValue)e : ((CIMProperty)e).getValue();
            Vector vector2 = (Vector)cIMValue.getValue();
            Trace.trace((String)TRACE_MASKD, (Object)("log entry id vector size:" + vector2.size()));
            if (bl3) {
                bl3 = false;
                n4 = 0;
                if (vector2.size() == 0) {
                    bl4 = false;
                }
                n = 2;
            } else {
                n4 = 1;
                if (vector2.size() <= 1) {
                    bl4 = false;
                }
            }
            long l4 = 0L;
            while (n4 < vector2.size() && bl4) {
                l4 = ((UnsignedInt32)vector2.get(n4)).longValue();
                if (!bl2 || bl2 && l4 != l2) {
                    Trace.trace((String)TRACE_MASKD, (Object)("Received id=" + Long.toString(l4, 16)));
                    vector.addElement(new Long(l4));
                    l3 = l4;
                } else {
                    bl4 = false;
                }
                ++n4;
            }
        } while (bl4);
        Trace.trace((String)TRACE_MASKD, (Object)("<-- getPELLogEntryIDs (" + vector.size() + " returned)"));
        return vector;
    }

    public byte[] getPEL(Long l) {
        Trace.trace((String)TRACE_MASKD, (Object)("--> getPEL (" + Long.toString(l, 16) + ")"));
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        vector.addElement(new CIMProperty("EntryID", new CIMValue((Object)new UnsignedInt32(l.toString()))));
        vector.addElement(new CIMProperty("LocCode", new CIMValue((Object)this.getLocationCode())));
        try {
            PIHscUtil.invokeCIMMethod("localhost", this.getFSPObjectPath(), "GetSPErrorLog", vector, vector2);
        }
        catch (CIMException cIMException) {
            Trace.trace((String)TRACE_MASKT, (Object)"Exception during CIM call");
            Trace.trace((String)TRACE_MASKT, (Object)((Object)cIMException));
            Trace.trace((String)TRACE_MASKD, (Object)"<-- getPEL: retrieval failed (no data returned).");
            return null;
        }
        if (vector2.size() <= 0) {
            Trace.trace((String)TRACE_MASKD, (Object)"<-- getPEL: retrieval failed (no data returned).");
            return null;
        }
        Object e = vector2.get(0);
        CIMValue cIMValue = null;
        cIMValue = e instanceof CIMValue ? (CIMValue)e : ((CIMProperty)e).getValue();
        Vector vector3 = (Vector)cIMValue.getValue();
        Trace.trace((String)TRACE_MASKD, (Object)("PEL size=" + vector3.size()));
        byte[] byArray = new byte[vector3.size()];
        for (int i = 0; i < vector3.size(); ++i) {
            byArray[i] = ((UnsignedInt8)vector3.get(i)).byteValue();
        }
        Trace.trace((String)TRACE_MASKD, (Object)"PEL >> ");
        if (vector3.size() == 0) {
            Trace.trace((String)TRACE_MASKD, (Object)"no data retrieved");
        } else {
            Trace.trace((String)TRACE_MASKD, (Object)byArray);
        }
        Trace.trace((String)TRACE_MASKD, (Object)"<< PEL");
        Trace.trace((String)TRACE_MASKD, (Object)"<-- getPEL");
        return byArray;
    }

    public void acknowledgePEL(Long l) {
        Trace.trace((String)TRACE_MASKD, (Object)("--> acknowledgePEL (" + Long.toString(l, 16) + ")"));
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        vector.addElement(new CIMProperty("EntryID", new CIMValue((Object)new UnsignedInt32(l.toString()))));
        vector.addElement(new CIMProperty("LocCode", new CIMValue((Object)this.getLocationCode())));
        try {
            PIHscUtil.invokeCIMMethod("localhost", this.getFSPObjectPath(), "AcknowledgePlatformEventLogEntry", vector, vector2);
        }
        catch (CIMException cIMException) {
            Trace.trace((String)TRACE_MASKT, (Object)"Exception during CIM call");
            Trace.trace((String)TRACE_MASKT, (Object)((Object)cIMException));
            Trace.trace((String)TRACE_MASKD, (Object)"<-- acknowledgePEL: acknowledgement failed");
            return;
        }
        Trace.trace((String)TRACE_MASKD, (Object)"<-- acknowledgePEL");
    }

    public Vector getPELs(Map map, boolean bl, long l, boolean bl2, long l2) {
        Trace.trace((String)TRACE_MASKD, (Object)"--> getPELs");
        Vector vector = this.getPELLogEntryIDs(map, bl, l, bl2, l2);
        Vector<byte[]> vector2 = new Vector<byte[]>();
        byte[] byArray = null;
        Long l3 = null;
        for (int i = 0; i < vector.size(); ++i) {
            l3 = (Long)vector.get(i);
            byArray = this.getPEL(l3);
            if (byArray == null || byArray.length == 0) {
                Trace.trace((String)TRACE_MASKD, (Object)("No data retrieved for (" + Long.toString(l3, 16) + ")"));
                continue;
            }
            vector2.addElement(byArray);
        }
        Trace.trace((String)TRACE_MASKD, (Object)("<-- getPELs (" + vector2.size() + " returned)"));
        return vector2;
    }

    public Map queryDump() {
        Trace.trace((String)TRACE_MASKD, (Object)"--> queryDump");
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put(KEY_ALL_DUMP_COUNT, new Integer(0));
        hashMap.put(KEY_SYSTEM_DUMP_COUNT, new Integer(0));
        hashMap.put(KEY_SP_DUMP_COUNT, new Integer(0));
        hashMap.put(KEY_SMA_DUMP_COUNT, new Integer(0));
        hashMap.put(KEY_OTHER_DUMP_COUNT, new Integer(0));
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        vector.addElement(new CIMProperty("side", new CIMValue((Object)this.getLocationCode())));
        try {
            PIHscUtil.invokeCIMMethod("localhost", this.getFSPObjectPath(), "QueryDump", vector, vector2);
        }
        catch (CIMException cIMException) {
            Trace.trace((String)TRACE_MASKT, (Object)"Exception during CIM call");
            Trace.trace((String)TRACE_MASKT, (Object)((Object)cIMException));
            Trace.trace((String)TRACE_MASKD, (Object)"<-- queryDump: query failed (counts left 0).");
            return hashMap;
        }
        if (vector2.size() != 2) {
            Trace.trace((String)TRACE_MASKD, (Object)"<-- queryDump: query failed (counts left 0).");
            return hashMap;
        }
        try {
            Object e = vector2.get(0);
            CIMValue cIMValue = null;
            cIMValue = e instanceof CIMValue ? (CIMValue)e : ((CIMProperty)e).getValue();
            Integer n = new Integer(((UnsignedInt32)cIMValue.getValue()).intValue());
            Trace.trace((String)TRACE_MASKD, (Object)("all dump count=" + n));
            hashMap.put(KEY_ALL_DUMP_COUNT, n);
            e = vector2.get(1);
            cIMValue = null;
            cIMValue = e instanceof CIMValue ? (CIMValue)e : ((CIMProperty)e).getValue();
            Vector vector3 = (Vector)cIMValue.getValue();
            Integer n2 = new Integer((String)vector3.get(0));
            Integer n3 = new Integer((String)vector3.get(1));
            Trace.trace((String)TRACE_MASKD, (Object)("system dump count=" + n2));
            Trace.trace((String)TRACE_MASKD, (Object)("sp dump count=" + n3));
            hashMap.put(KEY_SYSTEM_DUMP_COUNT, n2);
            hashMap.put(KEY_SP_DUMP_COUNT, n3);
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)"Exception obtaining counts");
            Trace.trace((String)TRACE_MASKT, (Object)exception);
        }
        Trace.trace((String)TRACE_MASKD, (Object)"<-- queryDump");
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireLock(PASystemLock pASystemLock) throws LockAcquisitionException, LockHeldException {
        Trace.trace((String)TRACE_MASKD, (Object)"--> acquireLock");
        if (!this.canCommunicate()) {
            Trace.trace((String)TRACE_MASKT, (Object)"<-- acquireLock (Can't communicate with FSP)");
            throw new LockAcquisitionException();
        }
        UnsignedInt32 unsignedInt32 = this.getCIMLockType(pASystemLock);
        Trace.trace((String)TRACE_MASKD, (Object)("lockId=" + unsignedInt32.intValue()));
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        vector.addElement(new CIMProperty("operationMode", new CIMValue((Object)new UnsignedInt8(1))));
        Vector<UnsignedInt32> vector3 = new Vector<UnsignedInt32>();
        vector3.addElement(unsignedInt32);
        vector.addElement(new CIMProperty("lockIds", new CIMValue(vector3, new CIMDataType(25))));
        CIMValue cIMValue = null;
        try {
            cIMValue = PIHscUtil.invokeCIMMethod("localhost", this.getFSPObjectPath(), "fspSupplementLock", vector, vector2);
        }
        catch (CIMException cIMException) {
            Trace.trace((String)TRACE_MASKT, (Object)"<-- acquireLock (CIMException during fspSupplementLock CIM call)");
            Trace.trace((String)TRACE_MASKT, (Object)((Object)cIMException));
            throw new LockAcquisitionException();
        }
        int n = 0;
        if (cIMValue.getValue() instanceof UnsignedInt8) {
            n = ((UnsignedInt8)cIMValue.getValue()).intValue();
        } else if (cIMValue.getValue() instanceof String) {
            n = Integer.parseInt((String)cIMValue.getValue());
        } else {
            Trace.trace((String)TRACE_MASKT, (Object)("<-- acquireLock (Internal Error - unknown CIM return type - " + cIMValue.getValue().getClass().getName() + ")"));
            throw new LockAcquisitionException();
        }
        if (n != 0) {
            Object e = vector2.get(1);
            CIMValue cIMValue2 = null;
            cIMValue2 = e instanceof CIMValue ? (CIMValue)e : ((CIMProperty)e).getValue();
            String string = (String)cIMValue2.getValue();
            PASystem pASystem = new PASystem();
            pASystem.setMachineType(string.substring(0, 4));
            pASystem.setMachineModel(string.substring(4, 7));
            pASystem.setMachineSerial(string.substring(string.indexOf("*") + 1));
            pASystem.setSystemName(pASystem.getMTMS());
            LockHeldException lockHeldException = new LockHeldException();
            lockHeldException.setLockHolder(pASystem);
            Trace.trace((String)TRACE_MASKT, (Object)("<-- acquireLock (lock held failure; holder MTMS=" + string + ")"));
            throw lockHeldException;
        }
        Object e = vector2.get(0);
        CIMValue cIMValue3 = null;
        cIMValue3 = cIMValue3 instanceof CIMValue ? (CIMValue)e : ((CIMProperty)e).getValue();
        UnsignedInt32 unsignedInt322 = (UnsignedInt32)cIMValue3.getValue();
        Map map = this.cimLockMap;
        synchronized (map) {
            this.cimLockMap.put(unsignedInt32, unsignedInt322);
        }
        Trace.trace((String)TRACE_MASKD, (Object)("<-- acquireLock (got lock; lockRequestId=" + unsignedInt322.intValue() + ")"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(PASystemLock pASystemLock) throws LockAcquisitionException {
        Trace.trace((String)TRACE_MASKD, (Object)"--> releaseLock");
        if (!this.canCommunicate()) {
            Trace.trace((String)TRACE_MASKT, (Object)"<-- releaseLock (Can't communicate with FSP)");
            throw new LockAcquisitionException();
        }
        UnsignedInt32 unsignedInt32 = this.getCIMLockType(pASystemLock);
        Trace.trace((String)TRACE_MASKD, (Object)("lockId=" + unsignedInt32.intValue()));
        UnsignedInt32 unsignedInt322 = null;
        Object object = this.cimLockMap;
        synchronized (object) {
            unsignedInt322 = (UnsignedInt32)this.cimLockMap.get(unsignedInt32);
        }
        if (unsignedInt322 == null) {
            Trace.trace((String)TRACE_MASKT, (Object)"<-- releaseLock (Internal Error - No lockRequestId?)");
            throw new LockAcquisitionException();
        }
        Trace.trace((String)TRACE_MASKD, (Object)("lockRequestId=" + unsignedInt322.intValue()));
        object = new Vector();
        Vector vector = new Vector();
        ((Vector)object).addElement(new CIMProperty("operationMode", new CIMValue((Object)new UnsignedInt8(2))));
        Vector<UnsignedInt32> vector2 = new Vector<UnsignedInt32>();
        vector2.addElement(unsignedInt32);
        vector2.addElement(unsignedInt322);
        ((Vector)object).addElement(new CIMProperty("lockIds", new CIMValue(vector2, new CIMDataType(25))));
        CIMValue cIMValue = null;
        try {
            cIMValue = PIHscUtil.invokeCIMMethod("localhost", this.getCIMObjectPath(), "fspSupplementLock", (Vector)object, vector);
        }
        catch (CIMException cIMException) {
            Trace.trace((String)TRACE_MASKT, (Object)"<-- releaseLock (CIMException during fspSupplementLock CIM call)");
            Trace.trace((String)TRACE_MASKT, (Object)((Object)cIMException));
            throw new LockAcquisitionException();
        }
        int n = 0;
        if (cIMValue.getValue() instanceof UnsignedInt8) {
            n = ((UnsignedInt8)cIMValue.getValue()).intValue();
        } else if (cIMValue.getValue() instanceof String) {
            n = Integer.parseInt((String)cIMValue.getValue());
        } else {
            Trace.trace((String)TRACE_MASKT, (Object)("<-- releaseLock (Internal Error - unknown CIM return type - " + cIMValue.getValue().getClass().getName() + ")"));
            throw new LockAcquisitionException();
        }
        Trace.trace((String)TRACE_MASKD, (Object)("rc=" + n));
        Trace.trace((String)TRACE_MASKD, (Object)"<-- releaseLock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PASystem getLockHolder(PASystemLock pASystemLock) throws LockAcquisitionException {
        Trace.trace((String)TRACE_MASKD, (Object)"--> getLockHolder");
        if (!this.canCommunicate()) {
            Trace.trace((String)TRACE_MASKT, (Object)"<-- getLockHolder (Can't communicate with FSP)");
            throw new LockAcquisitionException();
        }
        UnsignedInt32 unsignedInt32 = this.getCIMLockType(pASystemLock);
        Trace.trace((String)TRACE_MASKD, (Object)("lockId=" + unsignedInt32.intValue()));
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        vector.addElement(new CIMProperty("operationMode", new CIMValue((Object)new UnsignedInt8(3))));
        Vector<UnsignedInt32> vector3 = new Vector<UnsignedInt32>();
        vector3.addElement(unsignedInt32);
        vector.addElement(new CIMProperty("lockIds", new CIMValue(vector3, new CIMDataType(25))));
        CIMValue cIMValue = null;
        try {
            cIMValue = PIHscUtil.invokeCIMMethod("localhost", this.getCIMObjectPath(), "fspSupplementLock", vector, vector2);
        }
        catch (CIMException cIMException) {
            Trace.trace((String)TRACE_MASKT, (Object)"<-- getLockHolder (CIMException during fspSupplementLock CIM call)");
            Trace.trace((String)TRACE_MASKT, (Object)((Object)cIMException));
            throw new LockAcquisitionException();
        }
        int n = 0;
        if (cIMValue.getValue() instanceof UnsignedInt8) {
            n = ((UnsignedInt8)cIMValue.getValue()).intValue();
        } else if (cIMValue.getValue() instanceof String) {
            n = Integer.parseInt((String)cIMValue.getValue());
        } else {
            Trace.trace((String)TRACE_MASKT, (Object)("<-- getLockHolder (Internal Error - unknown CIM return type - " + cIMValue.getValue().getClass().getName() + ")"));
            throw new LockAcquisitionException();
        }
        if (n != 0) {
            Trace.trace((String)TRACE_MASKD, (Object)"<-- getLockHolder (lock not held)");
            return null;
        }
        Object e = vector2.get(0);
        CIMValue cIMValue2 = null;
        cIMValue2 = cIMValue2 instanceof CIMValue ? (CIMValue)e : ((CIMProperty)e).getValue();
        UnsignedInt32 unsignedInt322 = (UnsignedInt32)cIMValue2.getValue();
        Map map = this.cimLockMap;
        synchronized (map) {
            this.cimLockMap.put(unsignedInt32, unsignedInt322);
        }
        map = vector2.get(1);
        CIMValue cIMValue3 = null;
        cIMValue3 = map instanceof CIMValue ? (CIMValue)map : ((CIMProperty)map).getValue();
        String string = (String)cIMValue3.getValue();
        Trace.trace((String)TRACE_MASKD, (Object)("holder=" + string));
        PASystem pASystem = new PASystem();
        pASystem.setMachineType(string.substring(0, 4));
        pASystem.setMachineModel(string.substring(4, 7));
        pASystem.setMachineSerial(string.substring(string.indexOf("*") + 1));
        pASystem.setSystemName(pASystem.getMTMS());
        Trace.trace((String)TRACE_MASKD, (Object)("<-- getLockHolder (lockRequestId=" + unsignedInt322.intValue() + ")"));
        return pASystem;
    }

    protected UnsignedInt32 getCIMLockType(PASystemLock pASystemLock) throws LockAcquisitionException {
        if (pASystemLock.equals((Object)DUMP_LOCK)) {
            return new UnsignedInt32(2L);
        }
        Trace.trace((String)TRACE_MASKD, (Object)("<-> getCIMLockType (Unknown lock id [" + pASystemLock.getLockId() + "])"));
        throw new LockAcquisitionException();
    }
}

